<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$orders = [];
$error = '';

try {
    $conn = getAdminDBConnection();

    // Fetch all orders with user and service information
    $stmt = $conn->prepare("SELECT o.id, u.username, o.service_name, o.amount, o.status, o.created_at 
                           FROM orders o 
                           JOIN users u ON o.user_id = u.id 
                           ORDER BY o.created_at DESC");
    if ($stmt === false) {
        throw new Exception('Prepare orders statement failed: ' . $conn->error);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $orders[] = $row;
        }
    }
    $stmt->close();

} catch (Exception $e) {
    $error = 'حدث خطأ أثناء تحميل بيانات الطلبات: ' . $e->getMessage();
}

require_once '../header.php'; // Include header for consistent styling
?>

<div class="container bg-dark text-white mt-5">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="mb-0">إدارة الطلبات</h3>
            <a href="admin_add_order.php" class="btn btn-primary btn-sm">إضافة طلب جديد</a>
        </div>
        <div class="card-body">
            <?php 
            $message = $_GET['message'] ?? '';
            $message_type = $_GET['type'] ?? '';
            if (!empty($message)): ?>
                <div class="alert alert-<?= htmlspecialchars($message_type) ?>" role="alert">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>
            <?php if (isset($error)): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>المستخدم</th>
                            <th>الخدمة</th>
                            <th>المبلغ</th>
                            <th>الحالة</th>
                            <th>تاريخ الإنشاء</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($orders)): ?>
                            <?php foreach ($orders as $order): ?>
                            <tr>
                                <td><?= htmlspecialchars($order['id'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['username'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['service_name'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['amount'] ?? 'N/A') ?> $</td>
                                <td>
                                    <?php
                                    $status_class = '';
                                    $status_text = '';
                                    switch ($order['status']) {
                                        case 'pending':
                                            $status_class = 'warning';
                                            $status_text = 'قيد الانتظار';
                                            break;
                                        case 'completed':
                                            $status_class = 'success';
                                            $status_text = 'مكتمل';
                                            break;
                                        case 'cancelled':
                                            $status_class = 'danger';
                                            $status_text = 'ملغي';
                                            break;
                                        default:
                                            $status_class = 'secondary';
                                            $status_text = $order['status'];
                                    }
                                    ?>
                                    <span class="badge bg-<?= $status_class ?>"><?= $status_text ?></span>
                                </td>
                                <td><?= htmlspecialchars($order['created_at'] ?? 'N/A') ?></td>
                                <td>
                                    <a href="admin_edit_order.php?id=<?= htmlspecialchars($order['id'] ?? '') ?>" class="btn btn-sm btn-info">تعديل</a>
                                    <a href="admin_delete_order.php?id=<?= htmlspecialchars($order['id'] ?? '') ?>" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد أنك تريد حذف هذا الطلب؟');">حذف</a>
                                    <?php if ($order['status'] === 'pending'): ?>
                                        <a href="admin_update_order_status.php?id=<?= htmlspecialchars($order['id'] ?? '') ?>&status=completed" class="btn btn-sm btn-success" onclick="return confirm('هل أنت متأكد أنك تريد قبول هذا الطلب؟');">قبول</a>
                                        <a href="admin_update_order_status.php?id=<?= htmlspecialchars($order['id'] ?? '') ?>&status=cancelled" class="btn btn-sm btn-warning" onclick="return confirm('هل أنت متأكد أنك تريد رفض هذا الطلب؟');">رفض</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">لا توجد طلبات لعرضها.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once '../footer.php'; ?> 